#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import Toggles.ControllerAclToggleLib
import LauncherPlugin.Launcher
from LauncherPlugin.HttpService import configPath

def Plugin( context ):
   if not Toggles.ControllerAclToggleLib.toggleControllerAclEnabled():
      return

   config = context.lookup( 'pcs/config' )
   status = context.lookup( 'pcs/status' )
   apiSts = context.lookup( 'pcs/apiStatus' )

   controllerdbStatus = context.lookup( "controller/status" )
   defaultClusterStatus = context.lookup(
         'controller/cluster/statusDir.status/default' )

   httpdConfig = context.lookup( configPath( 'pcs' ) )
   httpdRunnability = { 'entity' : httpdConfig, 'qualAttr' : 'enabled' }

   httpAgentRunnability = [ ( { 'entity' : config, 'qualAttr' : 'enabled' },
                          { 'entity' : controllerdbStatus, 'qualAttr' : 'enabled' },
                          { 'entity' : defaultClusterStatus,
                            'qualAttr' : 'isStandaloneOrLeader' },
                          httpdRunnability,
                        ),
                        { 'entity' : apiSts, 'qualAttr' : 'enabled' } ]

   pcsHttpAgentCfg = { "name" : "PcsHttpAgent",
                       "exe" : "/usr/bin/PcsHttpAgent",
                       "argv" : [ "--ini", '/etc/uwsgi/PcsWsgiConf.ini' ],
                       "heartbeatPeriod" : 30,
                       "runnability" : httpAgentRunnability }

   context.agentConfigIs( context.activeSupervisorRoleName, pcsHttpAgentCfg )

   pcsAgentRunnability = [
         ( { 'entity' : config, 'qualAttr' : 'enabled' },
           { 'entity' : controllerdbStatus, 'qualAttr' : 'enabled' },
           { 'entity' : defaultClusterStatus, 'qualAttr' : 'isStandaloneOrLeader' },
         ),
         { 'entity' : status, 'qualAttr' : 'enabled' } ]

   pcsAgentCfg = { "name" : "Pcs",
                   "exe" : "/usr/bin/Pcs",
                   "argv" : [],
                   "heartbeatPeriod" : 60,
                   "runnability" : pcsAgentRunnability }

   context.agentConfigIs( context.activeSupervisorRoleName, pcsAgentCfg )
