#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):

   # the pcibusagent does use non-cell specific entries, but it cannot
   # do anything until the cell location is also available so wait on that to be
   # created
   pciDeviceMapConfig = "hardware/cell/%cellId/pciDeviceMap/config"
   runnability = [ { "qualPath" : pciDeviceMapConfig + ".pciDeviceConfig/%*" } ]
   agentCfg = { "name" : "PciBus",
                "exe" : "/usr/bin/PciBus",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability": runnability }

   roleName = context.allCellsRoleName
   context.agentConfigIs( roleName, agentCfg )
