# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   libConfig = context.lookup( 'hardware/pluto/library/config' )
   daemonDir = context.lookup( 'hardware/pluto/daemons' )

   agentName = 'PLXcvr'
   agentCfg = {
         'name' : agentName,
         'exe' : '/usr/bin/PLXcvr',
         'argv' : [],
         'heartbeatPeriod' : 30,
         'runnability' : (
            { 'entity' : libConfig, 'qualAttr' : 'libPath' },
            { 'entity' : libConfig, 'qualAttr' : 'isWhitebox' },
            { 'entity' : daemonDir, 'qualAttr' : 'warm' },
         )
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

