#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ProductAttributes

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   libConfig = context.lookup( 'hardware/pluto/library/config' )
   sysConfig = context.lookup( 'hardware/pluto/system/config' )

   agentName = 'PLSystem'
   agentCfg = {
      'name' : agentName,
      'exe' : '/usr/bin/PLSystem',
      'argv' : [],
      'heartbeatPeriod' : 30,
      'runnability' : (
         { 'entity' : sysConfig, 'qualAttr' : 'initialized' },
         { 'entity' : libConfig, 'qualAttr' : 'libPath' },
      )
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

   daemonAttributes = ProductAttributes.productAttributes().daemonAttributes
   if len( daemonAttributes ) != 0:
      for name in daemonAttributes.iterkeys():
         processConfig = {
            'name' : name,
            'exe' : '/usr/bin/PlutoDaemonLauncher',
            'argv' : [ name ],
            'heartbeatPeriod' : 0,
         }
         context.agentConfigIs( roleName, processConfig )
