#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( 'hardware/platform/slot/config' )
   libConfig = context.lookup( 'hardware/pluto/library/config' )
   daemonDir = context.lookup( 'hardware/pluto/daemons' )

   agentName = 'PLSlot'
   agentCfg = {
         'name' : agentName,
         'exe' : '/usr/bin/PLSlot',
         'argv' : [],
         'heartbeatPeriod' : 30,
         'runnability' : ( { 'entity' : libConfig, 'qualAttr' : 'libPath' },
                           { 'entity' : config, 'qualAttr' : 'slotConfig' },
                           { 'entity' : daemonDir, 'qualAttr' : 'warm' } )
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
