#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   libConfig = context.lookup( 'hardware/pluto/library/config' )
   daemonDir = context.lookup( 'hardware/pluto/daemons' )

   agentName = 'PLDevice'
   agentCfg = {
      'name' : agentName,
      'exe' : '/usr/bin/PLDevice',
      'argv' : [ "--sliceId=%(sliceId)s" ],
      'heartbeatPeriod' : 30,
      'runnability' : (
         [ { 'qualPath' :
             'hardware/platform/device/config/slice/%sliceId.tempSensor/%*' },
           { 'qualPath' :
             'hardware/platform/device/config/slice/%sliceId.powerSupply/%*' },
           { 'qualPath' :
             'hardware/platform/device/config/slice/%sliceId.poePort/%*' },
           { 'qualPath' :
             'hardware/platform/device/config/slice/%sliceId.fan/%*' },
           { 'qualPath' :
             'hardware/platform/device/config/slice/%sliceId.xcvrConfig/%*' },
           { 'qualPath' :
             'hardware/platform/device/config/slice/%sliceId.led/%*' } ],
         { 'entity' : libConfig, 'qualAttr' : 'libPath' },
         { 'entity' : daemonDir, 'qualAttr' : 'warm' }
      )
   }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
