#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgeps : import LauncherPlugin.Launcher

from LauncherPlugin.Rib import registerAgent

def Plugin( context ):
   # Ospf3 should run only when the device is in multi-agent mode
   runnability = ( { "qualPath" :
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Ospf3" }, )

   # Register Main Ospf3 ( BR )
   registerAgent( context, "Ospf3", runnability, [] )

   # Vrf Ospf3 ( VR ) is always conditional on the existence of vrf status
   vrfRunnability = \
       ( { "qualPath" : "cell/%cellId/routing/Ospf3VrfLaunchIndicator/%sliceId" }, )
   argv = "--z", "'client name %(sliceId)s ns-name ns-%(sliceId)s " \
          "vrfname %(sliceId)s servername vre_server'", "--sliceId=%(sliceId)s"
   registerAgent( context, "Ospf3-vrf", vrfRunnability, argv,
                 exeName="/usr/bin/Ospf3-vrf" )
