#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgeps : import LauncherPlugin.Launcher

from LauncherPlugin.Rib import registerAgent

def Plugin( context ):
   # Ospf should run only when the device is in multi-agent mode
   runnability = ( { "qualPath" :
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Ospf" }, )

   # Register Main Ospf ( BR )
   registerAgent( context, "Ospf", runnability, [] )

   # Vrf Ospf ( VR ) is always conditional on the existence of vrf status
   vrfRunnability = \
       ( { "qualPath" : "cell/%cellId/routing/OspfVrfLaunchIndicator/%sliceId" }, )
   argv = "--z", "'client name %(sliceId)s ns-name ns-%(sliceId)s " \
          "vrfname %(sliceId)s servername vre_server'", "--sliceId=%(sliceId)s"
   registerAgent( context, "Ospf-vrf", vrfRunnability, argv,
                 exeName="/usr/bin/Ospf-vrf" )
