#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( 'mgmt/openstack/config' )
   controllerdbStatus = context.lookup( 'controller/status' )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/default" )
   status = context.lookup( 'mgmt/openstack/status' )

   agentName = 'OpenStack'
   agentRunnability = [ ( { 'entity' : config,
                            'qualAttr' : 'enabled' },
                          { 'entity' : controllerdbStatus,
                            'qualAttr' : 'enabled' },
                          { 'entity' : defaultClusterStatus,
                            'qualAttr' : 'isStandaloneOrLeader' } ),
                          { 'entity' : status,
                            'qualAttr' : 'enabled' } ]
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/OpenStack',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability' : agentRunnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
