#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

openflowConfigPath = "openflow/config"

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( openflowConfigPath )
   status = context.lookup( "openflow/status" )

   agentCfg = { "name": "OpenFlow",
                "exe": "/usr/bin/OpenFlow",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": [ { "entity" : config,
                                   "qualAttr" : "enabled" },
                                 { "entity" : status,
                                   "qualAttr" : "active" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
