#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def enabled ( entity ):
   return { "entity": entity, "qualAttr": "enabled" }

def notEnabled( entity ):
   return { 'entity' : entity,
            'qualAttr' : 'enabled',
            'negate' : True }

def launchRequest( entity ):
   return { "qualPath" : "{}/%*".format( entity ) },

def getAgentRunnability ( context, withOcta=False ):
   openconfigEntity = context.lookup( "mgmt/gnmi/config" )
   openconfigStatusEntity = context.lookup( "mgmt/gnmi/status" )
   openconfigLaunchRequestEntity = context.lookup( "mgmt/gnmi/launchRequest" )
   restconfEntity = context.lookup( "mgmt/restconf/config" )
   restconfStatusEntity = context.lookup( "mgmt/restconf/status" )
   netconfEntity = context.lookup( "mgmt/netconf/config" )
   netconfStatusEntity = context.lookup( "mgmt/netconf/status" )
   octaEntity = context.lookup( "mgmt/octa/config" )

   if withOcta:
      octa = enabled ( octaEntity )
   else :
      octa = notEnabled( octaEntity )

   agentRunnability = ( [ enabled( openconfigEntity ),
                          enabled( openconfigStatusEntity ),
                          launchRequest( openconfigLaunchRequestEntity ),
                          enabled( restconfEntity ),
                          enabled( restconfStatusEntity ),
                          enabled( netconfEntity ),
                          enabled( netconfStatusEntity ), ],
                        octa )
   return agentRunnability

def Plugin( context ):
   agentCfg = { "name": "OpenConfig",
                "exe": "/usr/bin/OpenConfig",
                "argv": [],
                "runnability": getAgentRunnability( context ),
                "heartbeatPeriod": 30,
                "startupGracePeriod": 900, # give time for dumptypes
              }

   octaCfg = { "name": "Octa",
               "exe": "/usr/bin/Octa",
               "argv": [],
               "runnability": getAgentRunnability( context, withOcta=True ),
               "heartbeatPeriod": 30,
               "startupGracePeriod": 900, # give time for dumptypes
             }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
   context.agentConfigIs( roleName, octaCfg )
