#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = "ObjectTracking"

   trackingConfig = context.lookup( "tracking/config" )
   trackingStatus = context.lookup( "tracking/status" )

   agentCfg = { "name": agentName,
                "exe": "/usr/bin/ObjectTracking",
                "argv": [],
                "heartbeatPeriod" : 30,
                "runnability": [ { "entity" : trackingConfig,
                                   "qualAttr" : "interfaceObjectConfig" },
                                 { "entity" : trackingStatus,
                                   "qualAttr" : "trackedObjectStatus" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
