#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

hwCardConfigPath = 'hardware/card/config'

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   cardConfig = context.lookup( hwCardConfigPath )
   cardStatus = context.lookup( 'hardware/card/status' )

   # Configure the Card Agent to run on the "ActiveSupervisor" whenever
   # chassis config exists
   agentName = 'NorCalCard'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/NorCalCard',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability' : [ { 'entity' : cardConfig,
                                    'qualAttr' : 'pcieCardConfig' },
                                  { 'entity' : cardStatus,
                                    'qualAttr' : 'cardStatus' } ] }
   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, agentCfg )
