#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   topoAggStatus = context.lookup( 'topology/aggregator/status' )
   controllerdbStatus = context.lookup( "controller/status" )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/default" )

   agentName = "NetworkTopologyAggregator"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/NetworkTopologyAggregator",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability" : [ ( { 'entity' : controllerdbStatus,
                                      'qualAttr' : 'enabled' },
                                    { 'entity' : defaultClusterStatus,
                                      'qualAttr' : 'isStandaloneOrLeader' } ),
                                  { 'entity' : topoAggStatus,
                                    'qualAttr' : 'running' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
