#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   mgmtControllerConfig = context.lookup( 'mgmt/controller/config' )

   agentName = "NetworkTopology"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/NetworkTopology",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": [ { 'entity' : mgmtControllerConfig,
                   'qualAttr' : 'enabled' } ]
                }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

