#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( 'ip/nat/config' )
   status = context.lookup( 'ip/nat/status' )

   agentName = 'Nat'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/Nat',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability': [ { 'entity' : config,
                                   'qualAttr' : 'intfConfig' },
                                 { 'entity' : config,
                                   'qualAttr' : 'vrfConfig' },
                                 { 'entity' : status,
                                   'qualAttr' : 'intfStatus' } ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

