#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

mvrpConfigPath = 'mvrp/config'

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   mvrpConfig = context.lookup( mvrpConfigPath )
   mvrpStatus = context.lookup( "mvrp/status" )

   agentName = 'Mvrp'
   exeName = '/usr/bin/Mvrp'
   agentCfg = { "name": agentName,
                "exe": exeName,
                "argv": [],
                "heartbeatPeriod" : 30,
                "runnability": [ { "entity" : mvrpConfig,
                                   "qualAttr" : "intfEnable" },
                                 { "entity" : mvrpStatus,
                                   "qualAttr" : "mvrpEnabled" } ] }
   roleName = { 'sso' : context.allSupervisorsRoleName,
                'rpr' : context.activeSupervisorRoleName }

   context.agentConfigIs( roleName, agentCfg )
