#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=import-error, unused-import

import LauncherPlugin.Launcher  # Import used to generate dependency on Launcher

AGENT_NAME = 'MssPolicyMonitor'


def Plugin( context ):
   mssStatus = context.lookup( 'mss/status' )
   mssL3Status = context.lookup( 'mssl3/status' )
   mssPolicyMonStatus = context.lookup( 'msspolicymonitor/status' )
   agentConfig = {
      'name':  AGENT_NAME,
      'exe': '/usr/bin/MssPolicyMonitor',
      'argv': [],
      'heartbeatPeriod': 30,
      'runnability': [
         ( { 'entity' : mssStatus, 'qualAttr' : 'running' }, ),
         ( { 'entity' : mssL3Status, 'qualAttr' : 'running' }, ),
         ( { 'entity' : mssPolicyMonStatus, 'qualAttr' : 'running' }, ) ]
      }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentConfig )
