#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

msrpConfigPath = 'msrp/config'

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   msrpConfig = context.lookup( msrpConfigPath )
   msrpStatus = context.lookup( "msrp/status" )

   agentName = 'Msrp'
   exeName = '/usr/bin/Msrp'
   agentCfg = { "name": agentName,
                "exe": exeName,
                "argv": [],
                "heartbeatPeriod" : 90,
                "runnability": [ { "entity" : msrpConfig,
                                   "qualAttr" : "intfEnable" },
                                 { "entity" : msrpStatus,
                                   "qualAttr" : "msrpEnabled" } ] }
   roleName = { 'sso' : context.allSupervisorsRoleName,
                'rpr' : context.activeSupervisorRoleName }

   context.agentConfigIs( roleName, agentCfg )
