# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing6/multicast/agentstatus' )
   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'msdpEnabled' } ]

   agentCfg = { "name": "Msdp6",
                "exe": "/usr/bin/Msdp6",
                "argv": [ "--scheduled" ],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -50, #  see AID3426
                "runnability" : runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
