#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import

# Because of its 'runnability' setting, this agent is added to
# conditionalStartAgentsToIgnoreLauncherMsg in ArosTestPlugin to prevent spurious
# ptest failures due to unrecognized logs triggered by config change/tampering
import LauncherPlugin.Launcher

def Plugin( context ):
   mplsConfig = context.lookup( 'routing/mpls/config' )

   agentName = "MplsUtilLsp"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/MplsUtilLsp",
                "argv": [],
                "runnability": [
                   {
                      'entity': mplsConfig,
                      'qualAttr': 'mplsRouting'
                   },
                ],
                "heartbeatPeriod": 30 }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

