# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = 'MplsEtba'
   config = context.lookup( "routing/mpls/config" )

   agentConfig = {
      'name': agentName,
      'exe': '/usr/bin/MplsEtba',
      'argv': [],
      'heartbeatPeriod': 30,
      'runnability': [ { 'entity': config,
                         'qualAttr': 'mplsRouting' } ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentConfig )
