#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import

# Because of its 'runnability' setting, this agent is added to
# conditionalStartAgentsToIgnoreLauncherMsg in ArosTestPlugin to prevent spurious
# ptest failures due to unrecognized logs triggered by config change/tampering
import LauncherPlugin.Launcher
from ProcMgrLib import OOM_NONESSENTIAL_PROC

def Plugin( context ):
   config = context.lookup( "routing/mpls/config" )
   agentRuntimeStatus = context.lookup( "routing/mpls/agentRuntimeStatus",
                                        mountFlags='r' )

   agentName = 'Mpls'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/Mpls',
                'argv': [],
                'oomScoreAdj': OOM_NONESSENTIAL_PROC, # see AID3426
                'runnability': [ { "entity": config,
                                   "qualAttr": "mplsRouting", },
                                 { "entity": agentRuntimeStatus,
                                   "qualAttr": "agentEnabled", } ],
                'heartbeatPeriod': 30 }
   # run in all supervisor to support NSF
   roleName = { 'rpr': context.activeSupervisorRoleName,
                'sso': context.allSupervisorsRoleName }
   context.agentConfigIs( roleName, agentCfg )
