# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   bridgingCapabilities = context.lookup( 'bridging/hwcapabilities' )
   mldconfig = context.lookup( 'bridging/mldsnooping/config' )
   mldrunnablepath = 'bridging/mldsnooping/runnability/status/enabled'

   # This will be "mldSnoopingSupported" at some point
   runnability = [
                    (
                       { 'entity': bridgingCapabilities,
                         'qualAttr': 'mldSnoopingSupported'
                       },
                       { 'entity': mldconfig,
                         'qualAttr': 'vlanDefaultEnabled'
                       },
                    ),
                    { 'qualPath': mldrunnablepath },
                 ]

   agentCfg = { "name": "MldSnooping",
                "exe": "/usr/bin/MldSnooping",
                "argv": [ ],
                "heartbeatPeriod": 30,
                "oomScoreAdj": -300, # see AID3426
                "runnability": runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
