#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   mlagConfig = context.lookup( "mlag/config" )
   proto = context.lookup( "mlag/proto" )

   runnability = [ ( { 'entity' : mlagConfig, 'qualAttr' : 'enabled' },
                     { 'entity' : mlagConfig, 'qualAttr' : 'domainId' },
                     { 'entity' : mlagConfig, 'qualAttr' : 'localIntfId' },
                     { 'entity' : mlagConfig, 'qualAttr' : 'peerAddressConfigured' },
                     { 'entity' : mlagConfig, 'qualAttr' : 'peerLinkIntfId' } ),
                   { 'entity' : proto, 'qualAttr' : 'running' } ]
   for agentName in ( "Mlag", "MlagTunnel" ):
      agentCfg = { "name" : agentName,
                   "exe" : "/usr/bin/" + agentName,
                   "argv" : [],
                   "heartbeatPeriod" : 30,
                   "runnability" : runnability }

      roleName = { 'rpr' : context.activeSupervisorRoleName,
                   'sso' : context.allSupervisorsRoleName }
      context.agentConfigIs( roleName, agentCfg )
