#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
from LauncherPlugin.HttpService import configPath

def Plugin( context ):
   mcsAgentConfig = context.lookup( 'mcs/config/cli' )
   mcsAgentStatus = context.lookup( 'mcs/status/agent' )
   controllerdbStatus = context.lookup( 'controller/status' )
   cluserStatus = context.lookup( "controller/cluster/statusDir.status/default" )
   mcsClientConfig = context.lookup( 'mcs/switch/config' )
   mcsClientStatus = context.lookup( 'mcs/switch/status' )
   mgmtControllerStatus = context.lookup( 'mgmt/controller/status' )

   roleName = context.activeSupervisorRoleName


   # MCS Http Server
   httpdConfig = context.lookup( configPath( 'mcs' ) )

   httpAgentRunnability = [ ( { 'entity': mcsAgentConfig,
                                 'qualAttr': 'enabled' },
                              { 'entity': controllerdbStatus,
                                'qualAttr': 'enabled' },
                              { 'entity': cluserStatus,
                                'qualAttr': 'isStandaloneOrLeader' },
                              { 'entity': httpdConfig,
                                'qualAttr': 'enabled' } ),
                             { 'entity': mcsAgentStatus,
                               'qualAttr': 'enabled' },
                           ]

   mcsHttpAgentCfg = { "name": "McsHttpAgent",
                       "exe": "/usr/bin/McsHttpAgent",
                       "argv": [ "--ini", '/etc/uwsgi/McsWsgiConf.ini' ],
                       "heartbeatPeriod": 30,
                       "runnability": httpAgentRunnability }

   context.agentConfigIs( roleName, mcsHttpAgentCfg )

   # Mcs Server Agent
   mcsServiceRunnability = [ ( { 'entity': mcsAgentConfig,
                                 'qualAttr': 'enabled' },
                               { 'entity': controllerdbStatus,
                                 'qualAttr': 'enabled' },
                               { 'entity': cluserStatus,
                                 'qualAttr': 'isStandaloneOrLeader' } ),
                             { 'entity': mcsAgentStatus,
                               'qualAttr': 'enabled' },
                           ]
   mcsAgentCfg = { "name": "Mcs",
                "exe": "/usr/bin/Mcs",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": mcsServiceRunnability }

   context.agentConfigIs( roleName, mcsAgentCfg )

   # MCS Client Agent
   mcsClientRunability = [
      ( { 'entity': mcsClientConfig,
        'qualAttr': 'enabled' },
        { 'entity': mgmtControllerStatus,
           'qualAttr': 'enabled' } ),
      # If the McsClient is already running. Give it time to shutdown.
      { 'entity': mcsClientStatus,
         'qualAttr': 'running' },
   ]

   mcsClientAgentCfg = { "name": "McsClient",
         "exe": "/usr/bin/McsClient",
         "argv": [],
         "heartbeatPeriod": 30,
         "runnability": mcsClientRunability }

   context.agentConfigIs( roleName, mcsClientAgentCfg )

   # TwinCvxClient agent
   secondCvxConfig = context.lookup( 'mcs/switch/controller/config' )
   secondCvxStatus = context.lookup( 'mcs/switch/controller/status' )

   twinCvxClientRunability = [
      ( { 'entity': secondCvxConfig,
          'qualAttr': 'enabled' },
        { 'entity': secondCvxConfig,
          'qualAttr': 'controllerConfig' } ),
      { 'entity': secondCvxStatus,
        'qualAttr': 'enabled' }
   ]

   twinCvxClientAgentCfg = { "name": "TwinCvxClient",
         "exe": "/usr/bin/TwinCvxClient",
         "argv": [],
         "heartbeatPeriod": 30,
         "runnability": twinCvxClientRunability }

   context.agentConfigIs( roleName, twinCvxClientAgentCfg )
