# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import LauncherUtil
import Tac
import Toggles.McastVpnLibToggleLib

agentName = "McastVpn"


def Plugin( context ):
   if not Toggles.McastVpnLibToggleLib.toggleMcastVpnUnderlayMulticastEnabled():
      return
   AddressFamily = Tac.Type( "Arnet::AddressFamily" )

   IpTunnelGroupConfig = Tac.Type( "Routing::Multicast::IpTunnelGroupConfig" )
   ipTunnelGroupConfig = context.lookup( IpTunnelGroupConfig.mountPath )

   AgentRunningStatus = Tac.Type( "McastCommon::AgentRunningStatus" )
   agentRunningStatusMountPath = AgentRunningStatus.mountPath(
      AddressFamily.ipunknown, agentName )
   agentRunningStatus = context.lookup( agentRunningStatusMountPath )
   underlayMulticastConfig = {
      'entity': ipTunnelGroupConfig,
      'qualAttr': 'intfConfig',
   }
   mcastVpnAgentRunning = { 'entity': agentRunningStatus, 'qualAttr': 'running' }
   runnability = [
      underlayMulticastConfig, mcastVpnAgentRunning
   ]
   agentCfg = {
      "name": agentName,
      "exe": "/usr/bin/McastVpn",
      "argv": [],
      "heartbeatPeriod": 30,
      "runnability": runnability
   }

   role = LauncherUtil.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
