# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# MaintenanceMode runnability is defined to inform the Launcher when to
# start or stop MaintenanceMode agent.
# MaintenanceMode should be started whenever "maintenance" command is
# configured. But, once the agent is started, it should not be stopped until
# all the status created by the agent is cleaned up. So, the runnability is
# defined as an OR of config and status qualPaths.
# Both Rib and ArBgp depend on MaintenanceMode agent to come up and set the
# ready qualPath. Now that MaintenanceMode agent is conditionally runnable, we
# need to ensure that Rib and ArBgp do not wait for MaintenanceMode agent if
# it is not runnable. 
# getMmodeRunnability returns MaintenanceMode agent runnability condtions
# 1. If negate is True, the caller wants the conditions which evaluate to True
#    when MaintenanceMode is not runnable. So, we returns 
#    ( ( NOT configQualPath ) AND ( NOT statusQuaPath ) )
# 2. If negate is False, the caller wants the conditions which evaluate to True
#    when MaintenanceMode agent is runnable. So, we return
#    ( configQualPath OR statusQualPath )
def getMmodeRunnability( negate=False ):
   if negate:
      mmodeRunnability = ( 
            { "qualPath" : "maintenance/runnability/config/enabled",
              "negate" : True },
            { "qualPath" : "maintenance/runnability/status/enabled",
              "negate" : True } )
   else:
      mmodeRunnability = (
            [ { "qualPath" : "maintenance/runnability/config/enabled" },
              { "qualPath" : "maintenance/runnability/status/enabled" } ] )
   return mmodeRunnability
