#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
import EosVersion

def Plugin( context ):
   config = context.lookup( "macsec/input/cli" )
   status = context.lookup( "macsec/status" )
   runnability = [ { "entity" : config, "qualAttr" : "profile" },
                   { "entity" : config, "qualAttr" : "licenseConfig" },
                   { "entity" : status, "qualAttr" : "intfStatus" },
                   { "entity" : status, "qualAttr" : "cpStatus" },
                   { "entity" : status, "qualAttr" : "portStatus" },
                   { "entity" : status, "qualAttr" : "licenseEnabled" } ]

   agentCfg = { "name": "Macsec",
                "exe": "/usr/bin/Macsec",
                "argv": [ ],
                "heartbeatPeriod": 30,
                "runnability" : runnability }

   if EosVersion.VersionInfo( None ).isDPEVersion():
      del agentCfg [ "runnability" ]

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
