#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):

   lpConfig = context.lookup( 'loopprotect/config' )
   lpStatus = context.lookup( 'loopprotect/status' )

   agentName = 'LoopProtect'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/' + agentName,
                'argv': [],
                'heartbeatPeriod': 90,
                'runnability': [ { 'entity' : lpConfig,
                                   'qualAttr' : 'globalEnabled' },
                                 { 'entity' : lpStatus,
                                   'qualAttr' : 'running' } ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )


