#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   ldpEnabledVrfColl = context.lookup( "mpls/ldp/ldpEnabledVrfColl" )
   ldpStatusColl = context.lookup( "mpls/ldp/ldpStatusColl" )

   agentName = 'LdpAgent'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/LdpAgent',
                'argv': [],
                'runnability': [
                 {
                   "entity": ldpEnabledVrfColl,
                   "qualAttr": "enabledVrf",
                 },
                 {
                   "entity": ldpStatusColl,
                   "qualAttr": "status",
                 },
                 {
                   "entity": ldpStatusColl,
                   "qualAttr": "grStatus",
                 },
                ],
                "oomScoreAdj": -300, # see AID3426
                'heartbeatPeriod': 30 }
   # run in all supervisor to support NSF
   roleName = { 'rpr': context.activeSupervisorRoleName,
                'sso': context.allSupervisorsRoleName }
   context.agentConfigIs( roleName, agentCfg )
