# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps : import LauncherPlugin.Launcher

def Plugin( ctx ):
   # Launcher configuration
   cloudHaAwsConfig = ctx.lookup( "cloudha/awsconfig" )
   cloudHaAzureConfig = ctx.lookup( "cloudha/azureconfig" )
   cloudHaGcpConfig = ctx.lookup( "cloudha/gcpconfig" )

   runnability = [ { 'entity' : cloudHaAwsConfig, 'qualAttr' : 'enable' },
                   { 'entity' : cloudHaAzureConfig, 'qualAttr' : 'enable' },
                   { 'entity' : cloudHaGcpConfig, 'qualAttr' : 'enable' } ]
   agentName = 'CloudHa'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/CloudHa',
                'argv' : [],
                'heartbeatPeriod' : 60,
                'runnability' : runnability }
   roleName = ctx.activeSupervisorRoleName
   ctx.agentConfigIs( roleName, agentCfg )
   
