#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing/multicast/agentstatus' )
   bessAgentStatus = context.lookup( 'bess/agentstatus' )

   runnability = ( { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'multicastEnabled' },
                   { 'entity' : bessAgentStatus,
                     'qualAttr' : 'v4Enabled',
                     'negate' : True } )
   agentCfg = { "name": "KernelMfib",
                "exe": "/usr/bin/KernelMfib",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -400, #  see AID3426
                "runnability" : runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
