#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=F0401
import LauncherPlugin.HttpService

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   apiConfig = context.lookup( LauncherPlugin.HttpService.configPath( "JsonApi" ) )
   apiRunnability = [ { 'entity' : apiConfig,
                         'qualAttr' : 'enabled' } ]
   agentCfg = { "name" : "JsonApiApp",
                "exe" : "/usr/bin/JsonApiApp",
                "argv" : [ "--ini", "/etc/uwsgi/JsonWsgiApp.ini" ],
                "heartbeatPeriod" : 30,
                'runnability' : [ ( apiRunnability, ) ] }
   context.agentConfigIs( context.activeSupervisorRoleName, agentCfg )
