#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgeps : import LauncherPlugin.Launcher
from LauncherPlugin.Rib import registerAgent

def Plugin( context ):
   # -------------------------------------------------------------------------
   # Isis runs unconditionally on rpr standby supervisor. In all other cases,
   # the runnability condition must be satisfied to run the agent.
   # -------------------------------------------------------------------------
   runnability = ( { "qualPath" :
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Isis" }, )

   # Register Main Isis ( BR )
   registerAgent( context, "Isis", runnability, [] )

   # Vrf Isis ( VR ) is always conditional on the existence of vrf status
   vrfRunnability = \
      ( { "qualPath" : "cell/%cellId/routing/IsisVrfLaunchIndicator/%sliceId" }, )
   argv = "--z", "'client name %(sliceId)s ns-name ns-%(sliceId)s " \
          "vrfname %(sliceId)s servername vre_server'", "--sliceId=%(sliceId)s"
   registerAgent( context, "Isis-vrf", vrfRunnability, argv,
                  exeName="/usr/bin/Isis-vrf" )
