#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = "Ipv6RouterAdvt"

   ztpStatus = context.lookup( 'zerotouch/status' )
   runnabilityConfig = context.lookup( 'routing6/runnability/config' )
   routerAdvtStatus = context.lookup( 'routing6/routerAdvt/status' )
   runnability = [ { 'entity' : ztpStatus, 'qualAttr' : 'enabled' },
                   { 'entity' : runnabilityConfig, 'qualAttr' : 'vrf' },
                   { 'entity' : routerAdvtStatus,
                     'qualAttr' : 'routerAdvtDaemonActive' } ]
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Ipv6RouterAdvt",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "oomScoreAdj" : -300, #  see AID3426
                "runnability" : runnability
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
