#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):

   status = context.lookup( 'ipsec/capabilities/status' )
   agentName = "Ipsec"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Ipsec",
                "argv" : [],
                "heartbeatPeriod" : 45,
                "startupGracePeriod": 200,
                "runnability": [ { 'entity' : status,
                                   'qualAttr' : 'ipsecSupported' } ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
