# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   # Agent is runnable if either ( cliConfig::active is True, there is at least
   # one interface configured in cliConfig::interface, AND
   # hardwareConfig::featureSupported is True AND DHCP Relay is not running AND
   # DhcpServer is not running ) OR leaseStatus::active is True.
   # leaseStatus::active allows our agent to call destructors before
   # launcherPlugin destroys the agent. This flag is set to True upon
   # initialization of ipLockingRoot and is set to False when all SMs are done
   # cleaning up.
   arpInspectionStatus = context.lookup( "security/arpInspection/status" )
   ipsgConfig = context.lookup( "security/ipsg/config" )
   cliConfig = context.lookup( "iplocking/cliConfig" )
   hardwareConfig = context.lookup( "iplocking/hardware/config" )
   leaseStatus = context.lookup( "iplocking/leaseStatus" )
   dhcpRelayStatus = context.lookup( 'ip/helper/dhcprelay/status' )
   dhcpSnoopingStatus = context.lookup( 'bridging/dhcpsnooping/status' )
   dhcpSnooping6Status = context.lookup( 'bridging/dhcpsnooping/dhcp6Status' )
   dhcpServerStatus = context.lookup( 'dhcpServer/status' )
   reflectorNeighbors = context.lookup( "iplocking/reflectorNeighbors" )
   agentCfg = {
     "name": "IpLocking",
     "exe": "/usr/bin/IpLocking",
     "argv": [],
     "heartbeatPeriod": 30,
     "runnability": [ ( { "entity": cliConfig,
                          "qualAttr": "active" },
                        { "entity": hardwareConfig,
                          "qualAttr": "featureSupported" },
                        { "entity": arpInspectionStatus,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": ipsgConfig,
                          "qualAttr": "ipsgEnabledIntf",
                          "negate": True },
                        { "entity": dhcpRelayStatus,
                          "qualAttr": "runControl",
                          "negate": True },
                        { "entity": dhcpSnoopingStatus,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": dhcpSnooping6Status,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": dhcpServerStatus,
                          "qualAttr": "ipv4ServerDisabled" },
                        { "entity": dhcpServerStatus,
                          "qualAttr": "ipv6ServerDisabled" }
                      ),
                      { "entity": leaseStatus,
                        "qualAttr": "active" } ]
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )

   # IpLocking Reflector agent runs on the active supervisor whenever
   # the reflector configuration is enabled
   agentCfg = {
         "name": "IpLockingReflector",
         "exe": "/usr/bin/IpLockingReflector",
         "argv": [],
         "heartbeatPeriod": 30,
         "runnability": [ { "entity": cliConfig,
                            "qualAttr": "reflectorActive" },
                          { "entity": reflectorNeighbors,
                            "qualAttr": "runnable" } ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
