# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
import Toggles.InbandTelemetryCommonToggleLib

def Plugin( context ):
   if Toggles.InbandTelemetryCommonToggleLib.toggleFeatureInbandTelemetryEnabled():
      # InbandTelemetry agent runs if
      # 1) Sflow Agent is not running/configured and
      # 2) SampledFlowTracker is not running/configured and
      # 3) Hardware FlowTracker is not running/configured and (needs to be removed)
      # 4) PostcardTelemetry is not running and
      # 5) Inband Telemetry is enabled
      sflowConfig = context.lookup( "sflow/config" )
      sflowStatus = context.lookup( "sflow/status" )
      intConfig = context.lookup( 'inbandtelemetry/config' )
      sftConfig = context.lookup( 'flowtracking/config/sampled' )
      hwFtConfig = context.lookup( 'flowtracking/config/hardware' )
      sftLauncherPath = 'flowtracking/activeAgent/sft'
      hwFtLauncherPath = 'flowtracking/activeAgent/hwAccel'
      intLauncherPath = 'flowtracking/activeAgent/inbandTelemetry'
      postcardLauncherPath = 'postcardtelemetry/activeAgent/postcardTelemetry'
      startupGracePeriod = 300
      runnability = [
         (
            { 'entity': sflowConfig, 'qualAttr': 'enabled', 'negate': True },
            { 'entity': sflowStatus, 'qualAttr': 'active', 'negate': True },
            { 'entity': intConfig, 'qualAttr': 'enable' },
            { 'entity' : hwFtConfig, 'qualAttr' : 'enabled', 'negate' : True },
            { 'entity' : sftConfig, 'qualAttr' : 'enabled', 'negate' : True },
            { 'qualPath' : hwFtLauncherPath, 'negate' : True },
            { 'qualPath' : sftLauncherPath, 'negate' : True },
            { 'qualPath' : postcardLauncherPath, 'negate' : True },
         ),
         { 'qualPath' : intLauncherPath },
      ]

      agentCfg = {
        "name": "InbandTelemetry",
        "exe": "/usr/bin/InbandTelemetry",
        "argv": [],
        "heartbeatPeriod": 90,
        "startupGracePeriod": startupGracePeriod,
        "runnability": runnability
      }
      role = context.activeSupervisorRoleName
      context.agentConfigIs( role, agentCfg )
