#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing/multicast/agentstatus' )
   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'ihpEnabled' } ]

   agentCfg = { "name" : "IgmpHostProxy",
         "exe" : "/usr/bin/IgmpHostProxy",
         "argv" : [],
         "heartbeatPeriod" : 30,
         "oomScoreAdj" : -150, #  see AID3426
         "runnability": runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
