#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing/multicast/agentstatus' )
   igmpStatus = context.lookup( 'routing/igmp/status' )

   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'gmpEnabled' },
                   { 'entity' : igmpStatus,
                     'qualAttr' : 'keepRunning' } ]
   agentCfg = { "name": "Igmp",
                "exe": "/usr/bin/Igmp",
                "argv": [ ],
                "heartbeatPeriod": 30,
                "oomScoreAdj": -250, # see AID3426
                "runnability": runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

