#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):

   cliConfig = context.lookup( 'hsc/cliconfig' )
   controllerdbStatus = context.lookup( 'controller/status' )
   defaultClusterStatus = context.lookup(
      'controller/cluster/statusDir.status/default' )
   status = context.lookup( 'hsc/status' )

   roleName = context.activeSupervisorRoleName
   agentName = "Hsc"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Hsc",
                "argv": [ '--scheduled', ],
                "heartbeatPeriod": 60,
                "runnability" : [ ( { "entity" : cliConfig,
                                      "qualAttr" : "enableAgent" },
                                    { "entity" : controllerdbStatus,
                                      "qualAttr" : "enabled" },
                                    { "entity" : defaultClusterStatus,
                                       "qualAttr" : "isStandaloneOrLeader" } ),
                                  { "entity" : status,
                                    "qualAttr" : "running" } ] }

   context.agentConfigIs( roleName, agentCfg )

