# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   hwCapabilities = context.lookup( 'healthMonitor/hwCapabilities' )
   agentName = 'HealthMonitor'
   agentRunnability = [ { 'entity': hwCapabilities,
                          'qualAttr': 'healthMonitorSupported' } ]

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/HealthMonitor',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': agentRunnability,
              }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
