#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   cliConfig = context.lookup( 'health/cliConfig' )
   hwConfig = context.lookup( 'health/hwConfig' )
   status = context.lookup( 'health/status' )

   agentName = "HealthMgr"
   runnabilitySupported = { 'entity' : hwConfig,
                           'qualAttr' : 'supported' }
   runnabilityByDefaut = { 'entity' : hwConfig,
                           'qualAttr' : 'enabledByDefault' }
   runnabilityCliExists = { 'entity' : cliConfig,
                            'qualAttr' : 'configExists' } 
   runnabilityNotCliExists = { 'entity' : cliConfig,
                               'qualAttr' : 'configExists',
                               'negate' : True }
   runnabilityEnabled = { 'entity' : cliConfig,
                          'qualAttr' : 'enabled' }
   runnabilityStatusEnabled = { 'entity': status,
                                'qualAttr' : 'enabled' }
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/HealthMgr',
                'argv' : [],
                'heartbeatPeriod' : 30,
                # runnability = ( supported and ( ( !cliExists and enabledByDefault )
                #                                 or ( cliExists and enabled ) ) 
                #               or statusEnabled
                'runnability' : [ ( runnabilitySupported,
                                  [ ( runnabilityNotCliExists, runnabilityByDefaut ),
                                    ( runnabilityCliExists, runnabilityEnabled ) ] ),
                                  runnabilityStatusEnabled ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
