# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherPlugin.Launcher

def Plugin( context ):
   gribiEntity = context.lookup( "mgmt/gribi/config" )
   gribiStatusEntity = context.lookup( "mgmt/gribi/status" )

   agentCfg = { "name": "Gribi",
                 "exe": "/usr/bin/Gribi",
                 "argv": [],
                 "runnability": [ { "entity": gribiEntity,
                                    "qualAttr": "enabled" },
                                  { "entity": gribiStatusEntity,
                                    "qualAttr": "enabled" } ],
                 "heartbeatPeriod": 30,
                 "startupGracePeriod": 300 } # give time for dumptypes

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
