#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( 'goodbye/config' )
   status = context.lookup( 'goodbye/status' )

   runnability = [
         { 'entity' : config, 'qualAttr' : 'globalConfig' },
         { 'entity' : status, 'qualAttr' : 'agentActive' },
         ]

   agentName = "Goodbye"
   agentCfg = {
         'name' : agentName,
         'exe' : "/usr/bin/Goodbye",
         'argv' : [],
         'heartbeatPeriod' : 30,
         'runnability' : runnability
         }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
