#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   # the agent runs on a given slice when the Hardware for that Slice exists
   # Otherwise, the agent runs on a given cell when the Hardware::PciFpgaConfigDir
   # for that cell exists in "hardware/cell/<cellId>"

   agentCfg = { "name": "FpgaAgent",
                "exe": "/usr/bin/FpgaAgent",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability":
                   [ { "qualPath":
                        "hardware/cell/%cellId/fpga/config.pciFpgaConfig/%*" } ]
                }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

   # Launch the slice-specific version of the agent when FruPlugin has created
   # hardware/fpga/status/slice/%sliceId and hardware/slice/%sliceId/FruReady.
   # hardware/fpga/status/slice/%sliceId indicates that the card has FPGA(s).
   # hardware/slice/%sliceId/FruReady indicates that the card is powered-on.
   # Without FruReady this agent will restart upon FPGA Upgrade or when
   # NorCalCard power-cycles the board to reach card powered-on state.
   # We use launchName as FpgaAgent to match the name in mount profiles. See Scd
   # plugin for more details.
   sliceAgentCfg = { "name": "FpgaAgentSlice",
                     "launchName": "FpgaAgent",
                     "exe": "/usr/bin/FpgaAgent",
                     "argv": [ "--sliceId=%(sliceId)s" ],
                     "heartbeatPeriod": 30,
                     "runnability":
                        [ ( { 'qualPath' :
                           "hardware/fpga/status/slice/%sliceId.pciFpgaStatus/%*" },
                            { 'qualPath' : "hardware/slice/%sliceId/FruReady" } ) ]
                     }
   sliceRoleName = context.activeSupervisorRoleName
   context.agentConfigIs( sliceRoleName, sliceAgentCfg )
