#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = "Firewall"

   firewallCliConfig = context.lookup( "firewall/config/cli" )
   firewallOpenConfig = context.lookup( "firewall/config/openConfig" )
   firewallHwConfig = context.lookup( "firewall/hw/config" )
   firewallHwCapability = context.lookup( "firewall/hw/capability" )

   # Is Firewall enabled in CLI OR in HW config?
   cliOrHwConfigEnabled = [
         { "entity" : firewallCliConfig,
           "qualAttr" : "enabled" },
         { "entity" : firewallOpenConfig,
           "qualAttr" : "enabled" },
         { "entity" : firewallHwConfig,
           "qualAttr" : "active" } 
   ]
   # Does the platform support segment security?
   platformSupport = { "entity" : firewallHwCapability,
                       "qualAttr" : "segSecSupported" }
   # Set runnability to True if the platform supports AND enabled in CLI/HW config
   runnability = ( platformSupport, cliOrHwConfigEnabled )

   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Firewall",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
