#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):

   def configureAgent( agentName, exe ):
      fhrpConfig = context.lookup( "routing/fhrp/config" )
      dynVarpConfig = context.lookup( "routing/fhrp/input/dynVarpConfig/vcs" )
      fhrpStatusV4 = context.lookup( "routing/fhrp/status" )
      fhrpStatusV6 = context.lookup( "routing6/fhrp/status" )
      mlagStatus = context.lookup( "mlag/status" )
      vxlanRunnabilityDir = context.lookup( "routing/fhrp/input/runnability/vxlan" )
      agentCfg = { "name": agentName,
                   "exe": exe,
                   "argv": [ "--scheduled" ],
                   "heartbeatPeriod": 30,
                   'startupGracePeriod': 150,
                   "oomScoreAdj": -400, # see AID3426
                   "runnability": [ { "entity": fhrpConfig,
                                      "qualAttr": "fhrpConfigured" },
                                    { "entity": dynVarpConfig,
                                      "qualAttr": "isNonDefaultMac" },
                                    { "entity": fhrpStatusV4,
                                      "qualAttr": "fhrpActive" },
                                    { "entity": vxlanRunnabilityDir,
                                      "qualAttr": "vxlanEnabled" },
                                    { "entity": mlagStatus,
                                      "qualAttr": "peerMacRoutingEnabled" },
                                    { "entity": fhrpStatusV4,
                                      "qualAttr": "ipAddrVirtNatSmActive" },
                                    { "entity": fhrpStatusV6,
                                      "qualAttr": "ip6AddrVirtNatSmActive" },
                                    { "entity": fhrpStatusV4,
                                      "qualAttr": "macAddrVirtualActive" } ] }
      context.agentConfigIs( roleName, agentCfg )

   roleName = context.allSupervisorsRoleName

   configureAgent( "Fhrp", "/usr/bin/Fhrp" )
