#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps : import LauncherPlugin.Launcher

def Plugin( context ):
   # The EvpnrtrEncap agent requires a LauncherPlugin so that it can be started in
   # vEOS-lab duts.
   # Make the qualPath runnability the same as for ArBgp. 
   roleName = context.activeSupervisorRoleName
   agentName = "EvpnrtrEncap"
   exeName = "/usr/bin/EvpnrtrEncap"
   runnability = ( { "qualPath" : 
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Bgp" } )
   agentCfg = { "name": agentName,
                "exe": exeName,
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability" : runnability }

   context.agentConfigIs( roleName, agentCfg )
